--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)
--Return.PlaceLogistic("AirbaseName")						returns the logistics of a base in weight which can be increased by the landing of transport aircraft or helicopters


--List of Action functions for trigger actions:
--Action.None()																				--void action
--Action.Text("your briefing text")															--add briefing text
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--set campagn flag to value
--Action.AddCampFlag(flag-n, number)														--add or subtract to campaign flag
--Action.AddImage("filname.jpg")															--add briefing picture
--Action.CampaignEnd("win"/"draw"/"loss")													--end campaign
--Action.TargetActive("TargetName", boolean)												--set target active/inactive
--Action.AirUnitActive("UnitName", boolean)													--set unit active/inactive
--Action.SideBase("side", "BaseName")														--change le camp d'une base, ATTENTION, deplacer les unites avant--Action.SideBase("blue", "Incirlik Airbase")
--Action.AirUnitBase("UnitName", "BaseName")												--set unit base
--Action.AirUnitPlayer("UnitName", boolean)													--set unit playable
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--send reinforcement aircraft from one unit to another
--Action.AirUnitRepair()																	--repair damaged aircraft in all air units
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--add ground target intel updates to briefing
--Action.GroupHidden("GroupName", boolean)													--change vehicle/ship group hidden status
--Action.GroupProbability("GroupName", number 0-1)											--change vehicle/ship group probability status
																							--due to the way stats are reset for a new playrun upon completing a FirstMission, groups probability changed by trigger in first mission will not be carried over to second mission! Repeat trigger on second mission or use the trigger from mission 2 on only for flawless function.
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			'Action.Text("In the 2000s, the Syrians, feeling supported by an increasingly strong Russia, invaded Lebanon again, taking advantage of the relative passivity of Israel. The weak Lebanese forces were quickly swept away and only Beirut still resists. Miraculously, several Western countries then decided to come to the aid of Lebanon to stop the invasion and defend Beirut at all costs.")',
			'Action.Text("US forces sent a TF and several land bases grew in strength in Cyprus and Turkey.")',
			'Action.Text("Syrian ground forces are advancing in Lebanon and reaching the suburbs of Beirut. Artillery shells the city and the airport. Aviation still relies on aging Mig-21s, Mig-23s and a few Mig-25s. More modern Mig-29As are also active.")',
			'Action.Text("According to our information, easily transportable SAM-6 batteries were hastily installed in the territories conquered in Lebanon to the north and south of Beirut. These batteries will be our priority targets to allow easier access to Beirut airport, which should facilitate the establishment of an air bridge from Cyprus.")',
			'Action.Text("It will also be necessary to get rid of the artillery units which continually harass the airport from the front line or even the surrounding areas of the airport as quickly as possible. Mortar teams have indeed infiltrated and will certainly be difficult to locate due to their mobility.")',
			'Action.Text("The Syrian air forces do not seem to have taken the threats of intervention from the USA and its allies seriously because their activity is quite limited for the moment. We will have to take advantage of this because there is no doubt that the Syrian air force will react violently and quickly to our first attacks.")',
			'Action.Text("A final worrying element could be a direct intervention from Russia which increasingly feels capable of standing up to our air forces. We will need to carefully monitor Russian forces which could significantly increase the threat against our forces.")',
			'Action.Text("Annees 2000s les Syriens se sentant soutenus par une Russie de plus en plus forte ont envahi a nouveau le Liban profitant d une relative passivite d Israel. Rapidement les faibles forces libanaises ont ete balayees et seule Beyrouth resiste encore. Miraculeusement plusieurs pays occidentaux decident alors de venir en aide au Liban pour stopper l invasion et defendre Beyrouth coute que coute.")',
			'Action.Text("Les forces US ont envoye une TF et plusieurs bases terrestres sont montees en puissance sur Chypres et en Turquie.")',
			'Action.Text("Les forces Syriennes au sol progressent au liban et atteignent les faubourgs de Beyrouth. L artillerie pilonne la ville et l aeroport. L aviation repose encore sur des Mig-21 vieillissants, des Mig-23 et quelques Mig-25. Des Mig-29 plus modernes sont actifs egalement.")',
			'Action.Text("D apres nos renseignements des batteries de SAM-6 aisement transportables ont ete installees a la hate sur les territoires conquis au Liban au nord et au sud de Beyrouth. Ces batteries seront nos cibles prioritaires pour permettre un acces plus aise a l aeroport de Beyrouth ce qui devrait faciliter la mise en place d un pont aerien depuis Chypre.")',
			'Action.Text("Il restera egalement a se debarrasser le plus rapidement possible des unites d artillerie qui harcelent continuellement l aeroport depuis la ligne de front ou meme les abords de l aeroport. Des equipes de mortiers se sont en effet infiltrees et seront certainement difficiles a localiser en raison de leur mobilite.")', 
			'Action.Text("Les forces aeriennes Syriennes ne semblent pas avoir pris au serieux les menaces d intervention des USA et de leurs allies car leur activite est assez reduite pour l instant. Il faudra en profiter car nul doute que l armee de l air Syrienne reagira violemment et rapidement a nos premieres attaques.")',
			'Action.Text("Un dernier element inquietant pourrait etre une intervention directe de la Russie qui de plus en plus se sent capable de tenir tete a nos forces aeriennes. Il faudra surveiller attentivement les forces russes qui pourraient augmenter fortement la menace contre nos forces.")',
			'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 40',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Allied forces completely destroyed the Syrian forces. Good game.")',
			'Action.Text("Les forces alliees ont totalement detruit les forces syrienne. Bien joue.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.totalAirUnitAliveBySide("red") < 10',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("The Syrian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Syrians are no longer able to produce any sorties or offer any resistance. The NATO now owns complete air superiority.")',
			'Action.Text("L armee de l air syrienne est en ruine. Apres des frappes aeriennes repetees et des pertes desastreuses dans les combats air-air, les Syriens ne sont plus en mesure d effectuer aucune sortie ni d opposer aucune resistance. L OTAN possede desormais une superiorite aerienne totale.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 3"] = {
		active = true,
		once = true,
		condition = 'GroundZoneTarget["blue"]["A"].percent < 25',
		action = {
			'Action.CampaignEnd("win")',
			'Action.Text("Allied forces completely destroyed the Syrian army. Good game.")',
			'Action.Text("Les forces alliees ont totalement detruit l armee syrienne. Bien joue.")',
			'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("VFA-106") < 2',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Ongoing combat operations have exhausted your squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Allied Air Force to attain air superiority, US Central Command has decided to call of the air campaign against the enemy. Without destroying enemy airbases it seems unlikely that the coalition will be able to win this war.")',
			'Action.Text("Les operations de combat en cours ont epuise votre escadron. Le taux de pertes a atteint un niveau tel que les renforts ne sont plus en mesure de soutenir les operations de combat. Face a l echec des des forces aeriennes alliees a atteindre la superiorite aerienne, le Commandement central americain a decide de stopper la campagne aerienne contre lennemi. Il semble peu probable que la coalition puisse gagner cette guerre.")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Beirut-Rafic Hariri Airbase") == 0 or Return.TargetAlive("Beirut-Rafic Hariri Airbase Runway") == 0 ',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("After the Beirut-Rafic Hariri Airbase has been hit and crippled by air strikes the libanese defense collapsed and it will be impossible for NATO to save this country. This is a bitter defeat.")',
			'Action.Text("Apres que la base aerienne de Beyrouth-Rafic Hariri ait ete touchee et paralysee par des frappes aeriennes, la defense libanaise s est effondree et il sera impossible pour l OTAN de sauver ce pays. C est une defaite amere.")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 3"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 60',
		action = {
			'Action.CampaignEnd("loss")',
			'Action.Text("Syrian airforce was able to destroy enough allied forces to decide US Command to ask for a cease fire  and stop any Air missions. This is a bitter failure for the Allies.")',
			'Action.Text("L armee de lair syrienne a reussi a detruire suffisamment de forces alliees pour decider le commandement americain de demander un cessez-le-feu et d arreter toute mission aerienne. C est un echec cuisant pour les Allies.")',
			'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			'NoMoreNewspaper = true',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			'Action.CampaignEnd("draw")',
			'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to stop attacks in Georgia")',
			'NoMoreNewspaper = true',
		},
	},

----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},
	["Campaign Red first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 100',
		action = {
			'Action.Text("The enemy destroyed its first allied targets, you must defend them.")',
		},
	},
	["Campaign Red 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 80',
		action = {
			'Action.Text("The enemy destroyed nearly 20 percents of allied targets, you must defend them.")',
		},
	},
	["Campaign Red 30 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 70',
		action = {
			'Action.Text("Allies troops have sustained great damages. Enemy strike missions are too efficient and they will win this war soon")',
		},
	},
	["Campaign Red 35 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 65',
		action = {
			'Action.Text("Too much allied troops are neutralized. We will ask for a cease fire soon")',
		},
	},

	----- CARRIER MOVEMENT -----
	["TF-71 Patrol At Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >= 1',
		action = 'Action.ShipMission("TF-71", {{"CV-1-1", "CV-1-2", "CV-1-3", "CV-1-4"}}, 10, 8, nil)',
	},
	["TF-71 Patrol Zone 2"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >= 2',
		action = 'Action.ShipMission("TF-71", {{"CV-2-1", "CV-2-2", "CV-2-3", "CV-2-4"}}, 10, 8, nil)',
	},
	["TF-71 Patrol Zone 3"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Antiship battery 1") <= 20 and Return.Mission() >= 3',
		action = 'Action.ShipMission("TF-71", {{"CV-3-1", "CV-3-2", "CV-3-3", "CV-3-4"}}, 10, 8, nil)',
	},
	["LHA-Tarawa-Group Patrol ATest Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("LHA-Tarawa-Group", {{"LHA-T-1-1", "LHA-T-1-2", "LHA-T-1-3", "LHA-T-1-4"}}, 10, 8, nil)',
	},	
	
	-- ----- AIRBASE STRIKES -----
	-- ["Rayak Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Rayak Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Rayak Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Mezzeh Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Mezzeh Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Mezzeh Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Shayrat Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Shayrat Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Shayrat Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Wujah Al Hajar Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Wujah Al Hajar Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Wujah Al Hajar Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Tiyas Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Tiyas Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Tiyas Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Aleppo Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Aleppo Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Aleppo Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["An Nasiriyah Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("An Nasiriyah Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at An Nasiriyah Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Abu al-Duhur Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Abu al-Duhur Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Abu al-Duhur Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Damascus Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Damascus Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.AirUnitBase("677 Squadron", "Al-Dumayr")',
			-- 'Action.AirUnitBase("819 Squadron", "Al-Dumayr")',
			-- 'Action.Text("After the facilities at Damascus Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Al-Dumayr Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Al-Dumayr Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Al-Dumayr Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
			-- 'Action.moveToAnotherBaseOrDeactivate("277th Bomber Aviation Regiment", { "Tiyas", "Palmyra"})',
			-- 'Action.moveToAnotherBaseOrDeactivate("14th IAP", { "Tiyas", "Palmyra"})',
		-- },
	-- },
	-- ["Bassel Al-Assad Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Bassel Al-Assad Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Bassel Al-Assad Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Rene Mouawad Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Rene Mouawad Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Rene Mouawad Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Qabr as Sitt Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Qabr as Sitt Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.AirUnitBase("Russian Attack Helicopter Rgt", "Mezzeh")',
			-- 'Action.AirUnitBase("1st Syrian Attack Helicopter Rgt", "Mezzeh")',
			-- 'Action.Text("After the facilities at Qabr as Sitt Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	-- ["Qabr as Sitt Airbase Runway Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Qabr as Sitt Airbase Runway") < 50',
		-- once = false,
		-- action = {
			-- 'Action.AirUnitBase("Russian Attack Helicopter Rgt", "Mezzeh")',
			-- 'Action.AirUnitBase("1st Syrian Attack Helicopter Rgt", "Mezzeh")',			
		-- },
	-- },
	-- ["Qabr as Sitt Airbase Runway Repaired"] = {
		-- active = true,
		-- condition = '(Return.TargetAlive("Qabr as Sitt Airbase Runway") >= 50) and (Return.TargetAlive("Qabr as Sitt Airbase") >= campMod.RepairMinimumDestroyed)',
		-- once = false,
		-- action = {
			-- 'Action.AirUnitBase("Russian Attack Helicopter Rgt", "Qabr as Sitt")',
			-- 'Action.AirUnitBase("1st Syrian Attack Helicopter Rgt", "Qabr as Sitt")',			
		-- },
	-- },
	-- ["Beirut-Rafic Hariri Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Beirut-Rafic Hariri Airbase") < campMod.RepairMinimumDestroyed',
		-- action = {
			-- 'Action.Text("After the facilities at Beirut-Rafic Hariri Airbase have been hit by air strikes, air operations at this base came to a complete stop. The base is no longer ably to produce any aviation sorties.")',
		-- },
	-- },
	
	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR-Rene-Mouawad Site") == 0 and Return.TargetAlive("EWR-Rayak Site") == 0 and Return.TargetAlive("EWR-Mezzeh Site") == 0',
		action = {
			'Action.TargetActive("CAP North Syria", true)',
			'Action.TargetActive("CAP Center Syria", true)',
			'Action.TargetActive("CAP South Syria", true)',
			'Action.TargetActive("Abu al Duhur Airbase Alert 140 Km", false)',
			'Action.TargetActive("Bassel Al Assad Airbase Alert 80 Km", false)',
			'Action.TargetActive("An Nasiriyah Airbase Alert 250 Km", false)',
			'Action.TargetActive("Tiyas Airbase Alert 300 Km", false)',
			'Action.TargetActive("Shayrat Airbase Alert 230 Km", false)',
			'Action.TargetActive("Aleppo Airbase Alert 90 Km", false)',
			'Action.TargetActive("Al-Dumayr Airbase Alert 220 Km", false)',
			'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},
	-- ["CAP activation"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.Mission() > 1',
		-- action = {
			-- 'Action.TargetActive("CAP North Syria", true)',
			-- 'Action.TargetActive("CAP Center Syria", true)',
			-- 'Action.TargetActive("CAP South Syria", true)',
			-- 'Action.Text("It seems that Syrian Air Force decided to maintain constant air patrols near the coast after our first attacks")',
		-- },
	-- },
	
	----- TROOPS MOVEMENTS ------
	
	["Syrian-11th-Armored-Div-64th-Brig-Artillery activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1',
		action = {		'Action.TemplateActive("Syrian-11th-Armored-Div-64th-Brig-Artillery-T1.stm","Syrian-11th-Armored-Div-64th-Brig-Artillery-T2.stm","Syrian-11th-Armored-Div-64th-Brig-Artillery-T3.stm","Syrian-11th-Armored-Div-64th-Brig-Artillery-T4")',
		'Action.TargetActive("Syrian-11th-Armored-Div-64th-Brig-Artillery", true)',
		},
	},
	["Syrian-11th-Armored-Div-64th-Brig-Artillery mouvement"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Syrian-11th-Armored-Div-64th-Brig-Artillery") and Return.Mission() > 1 and Return.TargetAlive("Syrian-11th-Armored-Div-64th-Brig-Artillery") > 0',
		action = {		'Action.TemplateActive("Syrian-11th-Armored-Div-64th-Brig-Artillery-T1.stm","Syrian-11th-Armored-Div-64th-Brig-Artillery-T2.stm","Syrian-11th-Armored-Div-64th-Brig-Artillery-T3.stm","Syrian-11th-Armored-Div-64th-Brig-Artillery-T4")',
		'Action.Text("A Syrian artillery battery is pounding Beirut Airbase from the south or south east, it seems to move often so it will be difficult to localize it")',
		},
	},
	["Syrian-3rd-Armored-Div-25th-Brig-Artillery activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 3',
		action = {		'Action.TemplateActive("Syrian-3rd-Armored-Div-25th-Brig-Artillery-T1.stm","Syrian-3rd-Armored-Div-25th-Brig-Artillery-T2.stm","Syrian-3rd-Armored-Div-25th-Brig-Artillery-T3.stm","Syrian-3rd-Armored-Div-25th-Brig-Artillery-T4")',
		'Action.TargetActive("Syrian-3rd-Armored-Div-25th-Brig-Artillery", true)',
		},
	},
	["Syrian-3rd-Armored-Div-25th-Brig-Artillery mouvement"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Syrian-3rd-Armored-Div-25th-Brig-Artillery") and Return.Mission() > 3 and Return.TargetAlive("Syrian-3rd-Armored-Div-25th-Brig-Artillery") > 0',
		action = {		'Action.TemplateActive("Syrian-3rd-Armored-Div-25th-Brig-Artillery-T1.stm","Syrian-3rd-Armored-Div-25th-Brig-Artillery-T2.stm","Syrian-3rd-Armored-Div-25th-Brig-Artillery-T3.stm","Syrian-3rd-Armored-Div-25th-Brig-Artillery-T4")',
		'Action.Text("A Syrian artillery battery is pounding Beirut Airbase from the North or North east, it seems to move often so it will be difficult to localize it")',
		},
	},
	["Insurgent-Mortar-Team-1 activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 0',
		action = {
		'Action.TemplateActive("Insurgent-Mortar-Team-1-T1.stm","Insurgent-Mortar-Team-1-T2.stm","Insurgent-Mortar-Team-1-T3.stm")',
		'Action.TargetActive("Insurgent-Mortar-Team-1", true)',
		},
	},
	["Insurgent-Mortar-Team-1 mouvement"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Insurgent-Mortar-Team-1") and Return.Mission() > 0 and (Return.TargetAlive("Insurgent-Mortar-Team-1") > 0)',
		action = {
		'Action.TemplateActive("Insurgent-Mortar-Team-1-T1.stm","Insurgent-Mortar-Team-1-T2.stm","Insurgent-Mortar-Team-1-T3.stm")',
		'Action.Text("At least one mortar is pounding Beirut airport. Its position is estimated to the 145° and 2 or 3NM from the main airport terminal")',
		},
	},
	["Insurgent-Mortar-Team-2 activation"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 4',
		action = {		'Action.TemplateActive("Insurgent-Mortar-Team-2-T1.stm","Insurgent-Mortar-Team-2-T2.stm","Insurgent-Mortar-Team-2-T3.stm")',
		'Action.TargetActive("Insurgent-Mortar-Team-2", true)',
		},
	},
	["Insurgent-Mortar-Team-2 mouvement"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Insurgent-Mortar-Team-2") and Return.Mission() > 4 and (Return.TargetAlive("Insurgent-Mortar-Team-2") > 0)',
		action = {
		'Action.TemplateActive("Insurgent-Mortar-Team-2-T1.stm","Insurgent-Mortar-Team-2-T2.stm","Insurgent-Mortar-Team-2-T3.stm")',
		'Action.Text("At least one mortar is pounding Beirut airport. Its position is estimated to the 65° and 1 or 2NM from the main airport terminal")',
		},
	},
	["Insurgent-Mortar-Team-3 activation"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 6',
		action = {'Action.TemplateActive("Insurgent-Mortar-Team-3-T1.stm","Insurgent-Mortar-Team-3-T2.stm")',
		'Action.TargetActive("Insurgent-Mortar-Team-3", true)',
		},
	},
	["Insurgent-Mortar-Team-3 mouvement"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Insurgent-Mortar-Team-3") and Return.Mission() > 4 and (Return.TargetAlive("Insurgent-Mortar-Team-3") > 0)',
		action = {
		'Action.TemplateActive("Insurgent-Mortar-Team-3-T1.stm","Insurgent-Mortar-Team-3-T2.stm")',
		'Action.Text("At least one mortar is pounding Beirut airport. Its position is estimated to the 195° and 2 or 3NM from the main airport terminal")',
		},
	},
	["SAM-SA2-Frontline-North activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 4',
		action = {		'Action.TemplateActive("SAM-SA2-Frontline-North-T1.stm")',
		'Action.TargetActive("SAM-SA2-Frontline-North", true)',
		'Action.Text("A new SA-2 site is operational near the Beirut airport and nearly stop any flights in the vicinity")',
		},
	},	
	["Russian Expeditionary Force 1 activation"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 85',
		action = {'Action.TemplateActive("Russian Expeditionary Force 1-T1.stm")',
		'Action.TargetActive("Russian Expeditionary Force 1", true)',
		'Action.Text("A Russian Expeditionary Force column is moving south on the roads just to the north of Rayak airbase")',
		'Action.SetCampFlag(801, Return.Mission())',
		},
	},
	["Russian Expeditionary Force 1 alternate activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 14',
		action = {'Action.TemplateActive("Russian Expeditionary Force 1-T1.stm")',
		'Action.TargetActive("Russian Expeditionary Force 1", true)',
		'Action.Text("A Russian Expeditionary Force column is moving south on the roads just to the north of Rayak airbase")',
		'Action.AddImage("Russian Expeditionary Force 1-T1.png", "blue")',
		'Action.SetCampFlag(801, Return.Mission())',
		},
	},
	["Russian Expeditionary Force 1 move 2"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Russian Expeditionary Force 1") and Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 1) and (Return.TargetAlive("Russian Expeditionary Force 1") > 0)',
		action = {
		'Action.TemplateActive("Russian Expeditionary Force 1-T2.stm")',
		'Action.Text("Russian Expeditionary Column Force is moving west on the roads just to the west of Rayak Airbase")',
		'Action.AddImage("Russian Expeditionary Force 1-T2.png", "blue")',
		},
	},
	["Russian Expeditionary Force 1 move 3"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Russian Expeditionary Force 1") and Return.CampFlag(801) and (Return.Mission() == Return.CampFlag(801) + 2) and (Return.TargetAlive("Russian Expeditionary Force 1") > 0)',
		action = {
		'Action.TemplateActive("Russian Expeditionary Force 1-T3.stm")',
		'Action.Text("Russian Expeditionary Column Force is moving west on the roads just to the East of Beirut Airbase")',
		'Action.AddImage("Russian Expeditionary Force 1-T3.png", "blue")',
		},
	},
	["Russian-Expeditionary-Force-Arty-1 activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() >= Return.CampFlag(801) + 1)',
		action = {
		'Action.TemplateActive("Russian-Expeditionary-Force-Arty-1-T1.stm","Russian-Expeditionary-Force-Arty-1-T2.stm","Russian-Expeditionary-Force-Arty-1-T3.stm")',
		'Action.TargetActive("Russian-Expeditionary-Force-Arty-1", true)',
		},
	},
	["Russian-Expeditionary-Force-Arty-1 mouvement"] = {
		active = true,
		once = false,
		condition = 'Return.targetIsActive("Russian-Expeditionary-Force-Arty-1") and (Return.Mission() >= Return.CampFlag(801) + 1) and (Return.TargetAlive("Russian-Expeditionary-Force-Arty-1") > 0)',
		action = {
		'Action.TemplateActive("Russian-Expeditionary-Force-Arty-1-T1.stm","Russian-Expeditionary-Force-Arty-1-T2.stm","Russian-Expeditionary-Force-Arty-1-T3.stm")',
		'Action.Text("Russians heavy rocket launchers are pounding Beirut airport area.")',
		},
	},
	["SAM-SA10-Russian activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() >= Return.CampFlag(801) + 1)',
		action = {'Action.TemplateActive("SAM-SA10-Russian.stm")',
		'Action.TargetActive("SAM-SA10-Russian", true)',
		'Action.Text("A formidable russian SA-10 site appeared South East of Shayrat")',
		},
	},
	["Beirout airport targeting activation"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent <= 70',
		action = {'Action.TargetActive("Beirut-Rafic Hariri Airbase", true)',
		'Action.TargetActive("Beirut-Rafic Hariri Airbase Runway", true)',
		'Action.Text("Intelligence intercepted communications ordering enemy fighter jets to destroy Beirut airport and its runway. After the heavy losses suffered, the enemy does not want the airport to fall intact into our hands. We must defend it at all costs otherwise all our efforts will have been in vain.")',
		},
	},
	["Patriot in Beirut Stats"] = {
        active = true,
        once = false,
        condition = 'Return.PlaceLogistic("Beirut-Rafic Hariri") < 200000 ',
        action = {
        'Action.LogisticObjectif("Beirut-Rafic Hariri", 200000)',
        },
    },
	["Patriot in Beirut airborn activation"] = {
        active = true,
        once = true,
        condition = 'Return.PlaceLogistic("Beirut-Rafic Hariri") > 200000',
        action = {
        'Action.TemplateActive("Patriot in Beirut.stm")',
		'Action.TargetActive("Patriot in Beirut", true)',
		'Action.TargetActive("CAP Libanon Syria-Bis", true)',
		'Action.TargetActive("Abu al Duhur Airbase Alert 140 Km", false)',
		'Action.TargetActive("An Nasiriyah Airbase Alert 250 Km", false)',
		'Action.TargetActive("Bassel Al Assad Airbase Alert 80 Km", false)',
		'Action.TargetActive("Shayrat Airbase Alert 230 Km", false)',
		'Action.TargetActive("Tiyas Airbase Alert 300 Km", false)',
		'Action.TargetActive("Al-Dumayr Airbase Alert 220 Km", false)',
		'Action.Text("Patriot Site is active to defend Beirut")',
        },
    },
	["US_defense in Beirut Stats"] = {
        active = true,
        once = false,
        condition = 'Return.PlaceLogistic("Beirut-Rafic Hariri") < 100000 ',
        action = {
        'Action.LogisticObjectif("Beirut-Rafic Hariri", 100000)',
        },
    },
	["Us_defense in Beirut airborn activation"] = {
        active = true,
        once = true,
        condition = 'Return.PlaceLogistic("Beirut-Rafic Hariri") > 100000',
        action = {
        'Action.TemplateActive("Beirut_US_defense.stm")',
		'Action.Text("US Air defenses are active to defend Beirut")',
		'Action.Text("Hercules crews were able to provide enough Airplanes ans Shoppers Ammo to allow them to reload on Beirut Airport")',
        },
    },
	["Activate Light Guns in Beirut"] = {
        active = true,
        once = false,
        condition = 'Return.Mission() > 0',
        action = {
            'Action.TemplateActive("Light_Guns_T1.stm","Light_Guns_T2.stm")',
        },
    }, 

	
	----- AIR UNITS ACTIVATION -----
	["Desactivation B-52H"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 4',
		action = {
			'Action.AirUnitActive("69 BS", false)',
			'Action.Text("B-52H from 96 BS must stop long range missions to rest and replenish their potential")',
		},
	},
	["Activation B-52H"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 8',
		action = {
			'Action.AirUnitActive("69 BS", true)',
			'Action.Text("B-52H from 96 BS are back for long range missions against Syrian SAM sites")',
		},
	},
	["Desactivation2 B-52H"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 12',
		action = {
			'Action.AirUnitActive("69 BS", false)',
			'Action.Text("B-52H from 96 BS must stop long range missions to rest and replenish their potential")',
		},
	},
	["Activation 11th Attack Squadron"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("SAM-SA6-Tripoli") == 0 and Return.TargetAlive("SAM-SA6-Beirut-North") == 0 and Return.TargetAlive("SAM-SA6-Beirut-South") == 0 and Return.TargetAlive("SAM-SA6-Saida") == 0',
		action = {
			'Action.AirUnitActive("11th Attack Squadron", true)',
			'Action.TargetActive("AFAC Beirout North", true)',
			'Action.TargetActive("AFAC Beirout South", true)',
			'Action.TargetActive("AFAC Beirout East", true)',
			'Action.Text("US Reapers begin AFAC missions on the frontlines ")',
		},
	},
	["Activation C-130"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("SAM-SA6-Tripoli") == 0 and Return.TargetAlive("SAM-SA6-Beirut-North") == 0 and Return.TargetAlive("SAM-SA6-Beirut-South") == 0 and Return.TargetAlive("SAM-SA6-Saida") == 0',
		action = {
			'Action.AirUnitActive("136th AW", true)',
			'Action.TargetActive("Airlift Beirut-Rafic Hariri Airbase", true)',
			'Action.Text("C-130 will begin rotation between Cyprus and Beirut Airport")',
		},
	},
	["1st Syrian Attack Helicopter Rgt Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2',
		action = {
		'Action.AirUnitActive("1st Syrian Attack Helicopter Rgt", true)',
		},
	},
	["3rd Syrian Attack Helicopter Rgt Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 3',
		action = {
		'Action.AirUnitActive("3rd Syrian Attack Helicopter Rgt", true)',
		},
	},
	["825 Squadron Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1',
		action = {
		'Action.AirUnitActive("825 Squadron", true)',
		'Action.TargetActive("Abu al-Duhur Airbase Alert 140 Km", true)',
		'Action.TargetActive("Abu al-Duhur Airbase Alert 80 Km", true)',
		},
	},
	["679 Squadron Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2',
		action = {
		'Action.AirUnitActive("679 Squadron", true)',
		'Action.TargetActive("Bassel Al-Assad Airbase Alert 80 Km", true)',
		'Action.TargetActive("Bassel Al-Assad Airbase Alert 40 Km", true)',
		
		},
	},
	["67 Squadron Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 1',
		action = {
		'Action.AirUnitActive("67 Squadron", true)',
		'Action.TargetActive("Aleppo Airbase Alert 90 Km", true)',
		},
	},
	["699 Squadron Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2',
		action = {
		'Action.AirUnitActive("699 Squadron", true)',
		'Action.TargetActive("Al-Dumayr Airbase Alert 220 Km", true)',
		'Action.TargetActive("Al-Dumayr Airbase Alert 150 Km", true)',
		},
	},
	["685 Squadron Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 2',
		action = {
		'Action.AirUnitActive("685 Squadron", true)',
		},
	},
	["Russian 28 GvIAP Activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801)',
		action = {
		'Action.AirUnitActive("28 GvIAP", true)',		
		'Action.TargetActive("Al-Dumayr Airbase Alert 220 Km", true)',
		'Action.TargetActive("Al-Dumayr Airbase Alert 150 Km", true)',
		'Action.Text("It seems that Russians are getting more and more involved in this conflict : a new kind of Mig-29 Fighter Squadron appears in the Syrian sky")',
		},
	},
	["Russian 277th Bomber Aviation Regiment Activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() >= Return.CampFlag(801) + 1)',
		action = {
		'Action.AirUnitActive("277th Bomber Aviation Regiment", true)',
		'Action.AirUnitActive("Russian Attack Helicopter Rgt", true)',
		'Action.Text("A new kind of Russian Bomber appears in the Syrian sky : it could be the Su-34")',
		},
	},
	["Russian 14th IAP Activation"] = {
		active = true,
		once = true,
		condition = 'Return.CampFlag(801) and (Return.Mission() >= Return.CampFlag(801) + 1)',
		action = {
		'Action.AirUnitActive("14th IAP", true)',
		'Action.Text("A new kind of Russian Fighter appears in the Syrian sky : it could be the Su-30")',
		},
	},
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	
	
		
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
}




